using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "an arctic ogre corpse" )]
	public class IceOgreLord : ArcticOgreLord
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.CrushingBlow;
					case 1: return WeaponAbility.ArmorIgnore;
					case 2: return WeaponAbility.ParalyzingBlow;
			}
		}
      
      [Constructable]
		public IceOgreLord() : base()
		{
			Name = "snezny zlobr";
         SetStr( 900, 945 );
			SetDex( 160, 175 );

			SetHits( 1900, 2500 );

			SetDamage( 20, 35 );

			SetResistance( ResistanceType.Physical, 50, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 40, 70 );
			SetResistance( ResistanceType.Fire, 40, 70 );

			SetSkill( SkillName.MagicResist, 125.1, 140.0 );
			SetSkill( SkillName.Tactics, 90.1, 140.0 );
			SetSkill( SkillName.Wrestling, 90.1, 144.0 );
			SetSkill( SkillName.Anatomy, 90.1, 140.0 );

			VirtualArmor = 55;
		}

		public override Poison PoisonImmune{ get{ return Poison.Regular; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath{ get{ return false; } } //neutika pri malem poctu hp
      
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );
			
			defender.Stam -= Utility.Random( 5, 15 );
			defender.Mana -= Utility.Random( 5, 20 );
		}

		public IceOgreLord( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}